#ifndef __CSJPOSLIB__
#define __CSJPOSLIB__
#pragma once
#include<string>
using namespace std;
// ///////////////////////////////////////////////////////////////////
// ErrorCode Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_SUCCESS						0
#define CMP_E_CONNECTED					1001
#define CMP_E_DISCONNECT				1002
#define CMP_E_NOTCONNECT				1003
#define CMP_E_CONNECT_NOTFOUND          1004
#define CMP_E_CONNECT_OFFLINE           1005
#define CMP_E_NOCONTEXT					1006
#define CMP_E_BT_DISABLE				1007
#define CMP_E_BT_NODEVICE				1008
#define CMP_E_CONNECT_TIMEOUT			1009

#define CMP_E_ILLEGAL					1101
#define CMP_E_OFFLINE					1102
#define CMP_E_NOEXIST					1103
#define CMP_E_FAILURE					1104
#define CMP_E_TIMEOUT					1105
#define CMP_EPTR_COVER_OPEN				1201
#define CMP_EPTR_REC_EMPTY				1202
#define CMP_EPTR_BADFORMAT				1203
#define CMP_EPTR_TOOBIG					1204

// ///////////////////////////////////////////////////////////////////
// "connect" Method: "connectType" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_PORT_WiFi					0
#define CMP_PORT_USB					3

// ///////////////////////////////////////////////////////////////////
// "status" Method: return Code Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_STS_NORMAL					0
#define CMP_STS_COVER_OPEN				16
#define CMP_STS_PAPER_EMPTY				32
#define CMP_STS_PRINTEROFF				128

// ///////////////////////////////////////////////////////////////////
// "printText,printBitmap,printBarcode,printPDF417,printQRCode" Method: "alignment" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_ALIGNMENT_LEFT				0
#define CMP_ALIGNMENT_CENTER			1
#define CMP_ALIGNMENT_RIGHT				2

// ///////////////////////////////////////////////////////////////////
// "printText" Method: "attribute" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_FNT_DEFAULT					0
#define CMP_FNT_FONTB					1
#define CMP_FNT_BOLD					8
#define CMP_FNT_REVERSE					64
#define CMP_FNT_UNDERLINE				128

// ///////////////////////////////////////////////////////////////////
// "printText" Method: "textSize" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_TXT_1WIDTH					0
#define CMP_TXT_2WIDTH					16
#define CMP_TXT_3WIDTH					32
#define CMP_TXT_4WIDTH					48
#define CMP_TXT_5WIDTH					64
#define CMP_TXT_6WIDTH					80
#define CMP_TXT_7WIDTH					96
#define CMP_TXT_8WIDTH					112
#define CMP_TXT_1HEIGHT					0
#define CMP_TXT_2HEIGHT					1
#define CMP_TXT_3HEIGHT					2
#define CMP_TXT_4HEIGHT					3
#define CMP_TXT_5HEIGHT					4
#define CMP_TXT_6HEIGHT					5
#define CMP_TXT_7HEIGHT					6
#define CMP_TXT_8HEIGHT					7

// ///////////////////////////////////////////////////////////////////
// "printPaddingText" Method: "side" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_SIDE_RIGHT					0
#define CMP_SIDE_LEFT					1

// ///////////////////////////////////////////////////////////////////
// "printBitmap" Method: "width" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_BM_ASIS						(-11)

// ///////////////////////////////////////////////////////////////////
// "printBarCode" Method: "symbology" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_BCS_UPCA					101
#define CMP_BCS_UPCE					102
#define CMP_BCS_EAN8					103
#define CMP_BCS_EAN13					104
#define CMP_BCS_JAN8					105
#define CMP_BCS_JAN13					106
#define CMP_BCS_ITF						107
#define CMP_BCS_Codabar					108
#define CMP_BCS_Code39					109
#define CMP_BCS_Code93					110
#define CMP_BCS_Code128					111
#define CMP_BCS_Code128_Parsed			112
#define CMP_BCS_RSS14                   131
#define CMP_BCS_RSS_EXPANDED            132
#define CMP_BCS_GS1DATABAR              131
#define CMP_BCS_GS1DATABAR_E            132
#define CMP_BCS_GS1DATABAR_S            133
#define CMP_BCS_GS1DATABAR_E_S          134

// ///////////////////////////////////////////////////////////////////
// "printBarCode" Method: "textPosition" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_HRI_TEXT_NONE				0
#define CMP_HRI_TEXT_ABOVE				1
#define CMP_HRI_TEXT_BELOW				2

// ///////////////////////////////////////////////////////////////////
// "printPDF417" Method: "ECLevel" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_PDF417_EC_LEVEL_0			48
#define CMP_PDF417_EC_LEVEL_1			49
#define CMP_PDF417_EC_LEVEL_2			50
#define CMP_PDF417_EC_LEVEL_3			51
#define CMP_PDF417_EC_LEVEL_4			52
#define CMP_PDF417_EC_LEVEL_5			53
#define CMP_PDF417_EC_LEVEL_6			54
#define CMP_PDF417_EC_LEVEL_7			55
#define CMP_PDF417_EC_LEVEL_8			56

// ///////////////////////////////////////////////////////////////////
// "printQRCode" Method: "ECLevel" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_QRCODE_EC_LEVEL_L			48
#define CMP_QRCODE_EC_LEVEL_M			49
#define CMP_QRCODE_EC_LEVEL_Q			50
#define CMP_QRCODE_EC_LEVEL_H			51

// ///////////////////////////////////////////////////////////////////
// "cutPaper" Method: "option" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_CUT_FULL					(-1)
#define CMP_CUT_PARTIAL					(-2)
#define CMP_CUT_FULL_PREFEED			(-3)
#define CMP_CUT_PARTIAL_PREFEED			(-4)

// ///////////////////////////////////////////////////////////////////
// "markFeed" Method: "type" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_MF_TO_CUTTER				2
#define CMP_MF_TO_NEXT_TOF				8

// ///////////////////////////////////////////////////////////////////
// "openDrawer" Method: "drawer" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_DRAWER_1					1
#define CMP_DRAWER_2					2

// ///////////////////////////////////////////////////////////////////
// "transactionPrint" Method: "control" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_TP_TRANSACTION				11
#define CMP_TP_NORMAL					12

// ///////////////////////////////////////////////////////////////////
// "rotatePrint" Method: "rotation" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_RP_NORMAL					0x0001
#define CMP_RP_ROTATE180				0x0103

#define CMP_RP_BARCODE					0x1000
#define CMP_RP_BITMAP					0x2000

// ///////////////////////////////////////////////////////////////////
// "pageModePrint" Method: "control" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_PM_PAGE_MODE				1
#define CMP_PM_PRINT_SAVE				2
#define CMP_PM_NORMAL					3
#define CMP_PM_CANCEL					4

// ///////////////////////////////////////////////////////////////////
// "PageModePrintDirection" Method: "direction" Parameter Constants
// ///////////////////////////////////////////////////////////////////
#define CMP_PD_LEFT_TO_RIGHT			1
#define CMP_PD_BOTTOM_TO_TOP			2
#define CMP_PD_RIGHT_TO_LEFT			3
#define CMP_PD_TOP_TO_BOTTOM			4

namespace CSJPOSLib{
	class ESCPOSPrinter{
	public:
		ESCPOSPrinter();
		virtual ~ESCPOSPrinter();
		int Connect(int connectType, std::string addr);
		int Connect(int connectType, std::string, int port);
		int Connect(int connectType, std::string, int port, int timeout);
		int Disconnect(void);
		int SetEncoding(int codepage);
		int PrinterCheck();
		int Status();
		int PrintText(std::string data, int alignment, int attribute, int textSize);
		int PrintPaddingText(std::string data, int attribute, int textSize, int length, int side);
		int PrintBitmap(std::string fileName, int alignment);
		int PrintBitmap(std::string fileName, int width, int alignment);
		int PrintMemoryBitmap(char* data,int dataLength, int width, int alignment);
		int PrintNVBitmap(int nvImageNumber);
		int PrintBarCode(std::string data, int symbology, int height, int width, int alignment, int textPosition);
		int PrintPDF417(std::string data, int digits, int steps, int moduleWidth, int stepHeight, int ECLevel, int alignment);
		int PrintQRCode(std::string data, int moduleSize, int ECLevel, int alignment);
		int CutPaper(int percentage);
		int UnitFeed(int ufCount);
		int MarkFeed(int type);
		int OpenDrawer(int drawer, int pulsLen);
		int TransactionPrint(int control);
		int RotatePrint(int rotation);
		int PageModePrint(int control);
		int ClearPrintArea(void);
		int ClearOutput(void);
		int PrintData(char* data, int dataLength);
		int PrintNormal(std::string data);
		int GetVersionCode(void);
		std::string GetVersionName(void);
		std::string GetPageModeArea(void);
		std::string GetPageModePrintArea(void);
		int SetPageModePrintArea(std::string area);
		int GetPageModePrintDirection(void);
		int SetPageModePrintDirection(int direction);
		int GetPageModeHorizontalPosition(void);
		int SetPageModeHorizontalPosition(int position);
		int GetPageModeVerticalPosition(void);
		int SetPageModeVerticalPosition(int position);
		int SetRecLineSpacing(int number);
		int GetRecLineSpacing();
	private:
		void*		reserved;
	};
}
#endif
